<?php
/**
 * JfUploader 3.1 Freeware - Mambot
 *
 * Copyright (c) 2004-2013 TinyWebGallery
 * written by Michael Dempfle
 *
 * For the latest version please go to http://jfu.tinywebgallery.com
**/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
if (!defined('_VALID_TWG')) {
  define('_VALID_TWG', '42');
}

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botJFUploader' );

function botJFUploader( $published, &$row, &$params, $page=0 )
{
   global $mainframe,$mosConfig_absolute_path,$mosConfig_lang;

 $mycode = '';
 $regex = '/{jfuploader.*}/';

 // check whether mambot has been unpublished
 if ( !$published ) {
 	$row->text = preg_replace( $regex, '', $row->text );
 	return true;
 	}

/**
 *  Get language files
 */
 if (file_exists($mosConfig_absolute_path.'/administrator/components/com_jfuploader/language/'.$mosConfig_lang.'.php')) {
 	include_once ($mosConfig_absolute_path.'/administrator/components/com_jfuploader/language/'.$mosConfig_lang.'.php');
 } else if (file_exists($mosConfig_absolute_path.'/administrator/components/com_jfuploader/language/english.php')) {
 	include_once ($mosConfig_absolute_path.'/administrator/components/com_jfuploader/language/english.php');
} else {
   $mycode .= "<div style='padding:10px; margin:10px; border: 1px solid #555555;color: #000000;background-color: #f8f8f8; text-align:center; width:360px;'><b>Installation error</b><br>The JFUploader component can not be found. This component is required. Please install JFUploader first before you use this plugin/mambot.</div>";
   $row->text = preg_replace ($regex, $mycode, $row->text);
   return;
}

// we have to include the language first because we check the if the component ist installed.
$skip_error_handling = "true"; // avoids that the jfu logfile is used for everything!
$debug_file = '';
@ob_start();
require_once($mosConfig_absolute_path."/administrator/components/com_jfuploader/tfu/tfu_helper.php");
@ob_end_clean();
require_once($mosConfig_absolute_path."/components/com_jfuploader/jfuploader.html.php");
require_once($mosConfig_absolute_path."/administrator/components/com_jfuploader/jfuploader.class.php");

	// find all instances of mambot and put in $matches
	preg_match_all( $regex, $row->text, $matches );

	// Number of mambots
 	$count = count( $matches[0] );
 	// mambot only processes if there are any instances of the mambot in the text
 	if ( $count ) {
     JFUHelper::printCss();
 	   preg_match ( '/{jfuploader.*id=([\w_-]+).*}/', $row->text, $treffer );
 	   $id = $treffer[1];
     preg_match ( '/{jfuploader.*type=([0,1]{1}).*}/', $row->text, $treffer );
 	   $selector = $treffer[1];

      echo '<!-- JFU type: \'' . $selector . '\' id: \'' .  $id . '\' -->';
 	  if (isset($selector) && isset($id)) {
 	      if ($selector == "0" && $id == "1") { // admin profile!
            HTML_joomla_flash_uploader::wrongId($id);
          } else {
     	      $user = $mainframe->getUser();
              $old_error = error_reporting(0);
      		  $myId = JFUHelper::getProfileId($selector, $id, $user);
      		  error_reporting($old_error);
    		if ($myId >=0) {
    		   $mycode = showFlashPlugin($myId);
    		} else {
    		   $mycode = HTML_joomla_flash_uploader::wrongId($id, true);
            }
          }
      } else {
        $mycode .= "<div class='errordiv'>"._ERR_MAMBOT."</div>";
      }
      // Replace the text
      $row->text = preg_replace ($regex, $mycode, $row->text);
    }
    // we remove the JFU error handler
    if ($old_error_handler) {
      set_error_handler($old_error_handler);
    } else { // no other error handler set
      set_error_handler('on_error_no_output');
    }
}

function showFlashPlugin($id) {
	 global $database, $mainframe;;
	 $row = new joomla_flash_uploader($database);
	 $row->load($id);
	 if (!$row->resize_show) { // no profile found or no id!
	    return HTML_joomla_flash_uploader::wrongId($id, true);
	 } else {
	   $uploadfolder = $row->folder;
	   $user = $mainframe->getUser();
        // we check if we have a master profile!
       if ($row->master_profile == 'true') {
	      if ($user->id != 0) {
              if ($row->master_profile_mode == 'id') {
                 $uploadfolder = $uploadfolder . '/' . $user->id;
              } else {
                 if ($row->master_profile_lowercase == 'true') {
                   $uploadfolder = $uploadfolder . '/' . strtolower($user->username);
                 } else {
                   $uploadfolder = $uploadfolder . '/' . $user->username;
                 }
              }
              // we check if the folder exists - if not it is created!
              if (!file_exists($uploadfolder) && $uploadfolder != "") {
                $dir_chmod = JFUHelper::getVariable($database, 'dir_chmod');
                $result = mkdir($uploadfolder);
                if ($result && $dir_chmod != 0) {
                   @chmod($uploadfolder, $dir_chmod);
                }
                // if the copy directory exists we copy everything!
                $extra_dir = "components/com_jfuploader/default";
                if (file_exists($extra_dir)) {
                  JFUHelper::dir_copy($extra_dir, $uploadfolder);
                }
              }
          } else {
              HTML_joomla_flash_uploader::noUser($id);
              return;
          }
       }
       // we go back to the main folder!
       if ($uploadfolder == "") {
         $folder =  "./../../../..";
       } else {
         $folder =  "./../../../../" . $uploadfolder;
       }
       JFUHelper::setJFUSession($row, $folder);
       unset($_SESSION["IS_ADMIN"]);
       $_SESSION["IS_FRONTEND"] = "TRUE";
       if ($user->id != 0) {
         $_SESSION["TFU_USER"] = $user->username;
         $_SESSION["TFU_USER_ID"] = $user->id;
         $_SESSION["TFU_USER_NAME"] = $user->name;
         $_SESSION["TFU_USER_EMAIL"] = $user->email;
       } else {
         unset($_SESSION["TFU_USER"]);
         unset($_SESSION["TFU_USER_ID"]);
         unset($_SESSION["TFU_USER_NAME"]);
         unset($_SESSION["TFU_USER_EMAIL"]);
       }

        // we check if the flash should be included with js oder the object tag
       $use_js_include = JFUHelper::check_js_include($database);

       store_temp_session();
       JFUHelper::fixSession();
       return  HTML_joomla_flash_uploader::showFlash( $row, $uploadfolder, $use_js_include, true );
	 }
}

?>